using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        var reader = new FastScanner();
        int n = reader.NextInt();

        long[] x = new long[n];
        long[] h = new long[n];

        for (int i = 0; i < n; i++) x[i] = reader.NextLong();
        for (int i = 0; i < n; i++) h[i] = reader.NextLong();

        int[] L = new int[n];
        int[] R = new int[n];
        Array.Fill(L, -1);
        Array.Fill(R, -1);

        // ???? ????
        Stack<int> st = new Stack<int>();
        for (int i = 0; i < n; i++)
        {
            while (st.Count > 0 && h[st.Peek()] < h[i]) st.Pop();
            if (st.Count > 0) L[i] = st.Peek();
            st.Push(i);
        }

        // ????? ????
        st.Clear();
        for (int i = n - 1; i >= 0; i--)
        {
            while (st.Count > 0 && h[st.Peek()] < h[i]) st.Pop();
            if (st.Count > 0) R[i] = st.Peek();
            st.Push(i);
        }

        StringBuilder sb = new StringBuilder();
        const double SQRT2 = 1.4142135623730951;

        for (int i = 0; i < n; i++)
        {
            double ans = double.PositiveInfinity;

            // ???????
            if (L[i] != -1)
                ans = Math.Min(ans, Dist(x[i], h[i], x[L[i]], h[L[i]]));
            if (R[i] != -1)
                ans = Math.Min(ans, Dist(x[i], h[i], x[R[i]], h[R[i]]));

            // ????? ????
            if (i > 0 && Math.Max(h[i], h[i - 1]) >= h[i])
            {
                long d = Math.Abs(h[i - 1] - h[i]);
                ans = Math.Min(ans, SQRT2 * d);
            }

            // ????? ?????
            if (i + 1 < n && Math.Max(h[i], h[i + 1]) >= h[i])
            {
                long d = Math.Abs(h[i + 1] - h[i]);
                ans = Math.Min(ans, SQRT2 * d);
            }

            if (double.IsInfinity(ans))
                sb.AppendLine("-1");
            else
                sb.AppendLine(ans.ToString("0.############"));
        }

        Console.Write(sb.ToString());
    }

    static double Dist(long x1, long y1, long x2, long y2)
    {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.Sqrt(dx * dx + dy * dy);
    }
}

class FastScanner
{
    private readonly byte[] buffer = new byte[1 << 16];
    private int ptr = 0, len = 0;

    private int ReadByte()
    {
        if (ptr >= len)
        {
            len = Console.OpenStandardInput().Read(buffer, 0, buffer.Length);
            ptr = 0;
            if (len <= 0) return -1;
        }
        return buffer[ptr++];
    }

    public int NextInt() => (int)NextLong();

    public long NextLong()
    {
        int c;
        while ((c = ReadByte()) <= ' ' && c != -1) ;
        long sign = 1;
        if (c == '-')
        {
            sign = -1;
            c = ReadByte();
        }
        long val = 0;
        while (c > ' ')
        {
            val = val * 10 + (c - '0');
            c = ReadByte();
        }
        return val * sign;
    }
}